#include "SamplerStates.hlsli"

// The rendertarget to render
Texture2D SourceTex : register(t0);

struct PSInput {
	float4 Position : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

#include "Common.hlsli"

float4 main(PSInput input) : SV_TARGET
{
	return SourceTex.SampleLevel(LinearSampler, input.TexCoords, 0);
}
